<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_ControllerPublic_Thread extends XFCP_sonnbStopSpamHere_ControllerPublic_Thread
{

    public function actionAddReply()
    {
        $message = $this->getHelper('Editor')->getMessageText('message', $this->_input);
        
        $threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
        $sshModel = sonnbStopSpamHere_Model_SSH::getInstance();
        
        if ($sshModel->_hasLinkCheck('reply') && 
        		(empty($sshModel->linkCheckNodes) || in_array($forum['node_id'], $sshModel->linkCheckNodes)))
        {
            $return = $sshModel->checkLink(sonnbStopSpamHere_Model_SSH::TYPE_POST, $threadId, $message);
                    
            if ($return)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_LINK,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('link', array(
                            'post'=> $sshModel->options->sonnbStopSpamHere_linkDisabledPostCount, 
                            'day'=> $sshModel->options->sonnbStopSpamHere_linkDisabledJoinDate
                        ));
                        break;
                    case 'moderate':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE] = $dwData;
                        break;
                    case 'pc':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION] = $dwData;
                        break;
                    case 'report':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT] = $dwData;
                        break;
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }

        if ($sshModel->_hasKeywordCheck('reply') && 
        		(empty($sshModel->keywordCheckNodes) || in_array($forum['node_id'], $sshModel->keywordCheckNodes)))
        {
            $return = $sshModel->checkKeyword(sonnbStopSpamHere_Model_SSH::TYPE_POST, $threadId, $message);
            
            if ($return)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_KEYWORD,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError('keyword', array(
                            'keywords'=>implode('","', $return['data']['matches'])
                        ));
                        break;
                    case 'moderate':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE] = $dwData;
                        break;
                    case 'pc':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION] = $dwData;
                        break;
                    case 'report':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT] = $dwData;
                        break;
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        if ($sshModel->_hasAkismetCheck('reply') && 
        		(empty($sshModel->akismetCheckNodes) || in_array($forum['node_id'], $sshModel->akismetCheckNodes)))
        {
            $return = $sshModel->checkAkismet(sonnbStopSpamHere_Model_SSH::TYPE_POST, $threadId, $message);
            
            if ($return)
            {
                $dwData = array(
                    'type' => sonnbStopSpamHere_Model_SSH::LOG_TYPE_AKISMET,
                    'data' => $return['data']
                );
                
                switch ($return['action'])
                {
                    case 'block':
                        $this->throwError();
                        break;
                    case 'moderate':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_MODERATE] = $dwData;
                        break;
                    case 'pc':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_CONVERSATION] = $dwData;
                        break;
                    case 'report':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_REPORT] = $dwData;
                        break;
                    case 'allow':
                        $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_POST_ALLOW] = $dwData;
                    default:
                        break;
                }
            }
        }
        
        return parent::actionAddReply();
    }
    
    public function throwError($type='default', $data = array())
    {
        $params = array();
        switch ($type)
        {
            case 'link':
                $params = $data;
                if (empty($params['post']) && !empty($params['day']))
                {
                    $type .= '_day';
                }
                elseif (empty($params['day']) && !empty($params['post']))
                {
                    $type .= '_post';
                }
                elseif (empty($params['day']) && empty($params['post']))
                {
                    $type .= '_no_reason';
                }
                break;
            case 'keyword':
                $params = $data;
                break;
            case 'default':
            default:
                $params = array('contactUrl' => sonnbStopSpamHere_Model_Log::getContactUrl());
                break;
        }
        
        throw $this->responseException(
                $this->responseError(
                        new XenForo_Phrase(
                                'sonnbStopSpamHere_post_stop_message_'.$type,
                                $params
                            )
                        , 403)
                );
    }

}